package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansExport.java 3913 2014-03-30 21:46:34Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansExport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author David Cossé
 */
public class GrowingPlansExport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(GrowingPlansExport.class);
    private static final long serialVersionUID = 6124361181629908425L;

    protected List<String> growingPlanIds;

    protected transient GrowingPlanService growingPlanService;

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "application/vnd.ms-excel",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        return SUCCESS;
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = growingPlanService.exportGrowingPlanAsXlsStream(growingPlanIds);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate xsl", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setGrowingPlanIds(List<String> growingPlanIds) {
        this.growingPlanIds = growingPlanIds;
    }

    public String getFilename() {
        String filename = "growing-plans-export.xls";
        return filename;
    }

}
