package fr.inra.agrosyst.web.actions.generic;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GenericEntitiesListJson.java 3241 2014-02-14 09:40:30Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/generic/GenericEntitiesListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.api.services.generic.GenericFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class GenericEntitiesListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -4267342874222046159L;

    protected transient GenericEntityService service;

    protected String genericClassName;

    protected String filter;

    protected ResultList<?> elements;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }


    @Override
    public String execute() {
        GenericFilter rawFilter = getGson().fromJson(filter, GenericFilter.class);
        elements = service.listEntitiesFromString(genericClassName, rawFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return elements;
    }
}
