package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ValidateDomain.java 3445 2014-02-24 15:48:36Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/ValidateDomain.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Validation d'un domaine.
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 * @since 0.8
 */
public class ValidateDomain extends AbstractAgrosystAction {

    private static final long serialVersionUID = 8258866040086672722L;

    protected transient DomainService domainService;

    protected String domainTopiaId;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "domains-edit-input", "domainTopiaId", "${domainTopiaId}"})})
    public String execute() throws Exception {
        Domain domain = domainService.validateAndCommit(domainTopiaId);

        notificationSupport.domainValidated(domain);
        return SUCCESS;
    }

    public String getDomainTopiaId() {
        return domainTopiaId;
    }

}
