package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: MaterielDto.java 3963 2014-04-02 09:42:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/MaterielDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.MaterielType;

/**
 * MaterielDTO used to edit {@code Materiel} using struts.
 * 
 * @author Eric Chatellier
 */
public class MaterielDto implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5438715230325344950L;

    protected String topiaId;

    /**
     * Key that allow the binding of material loaded from a JSP when no topiaId are defined on it.
     */
    protected String hashKey;

    protected String name;

    protected String description;

    protected boolean materielETA;

    protected String materielTopiaId;

    protected MaterielType materielType;

    protected String typeMateriel1;

    protected String typeMateriel2;

    protected String typeMateriel3;

    protected String typeMateriel4;

    protected double uniteParAn;

    protected String unite;
    
    protected String performanceUnite;
    
    protected Double performance;

    public MaterielDto() {
        
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return Strings.emptyToNull(description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMaterielETA() {
        return materielETA;
    }

    public void setMaterielETA(boolean materielETA) {
        this.materielETA = materielETA;
    }

    public String getMaterielTopiaId() {
        return materielTopiaId;
    }

    public void setMaterielTopiaId(String materielTopiaId) {
        this.materielTopiaId = materielTopiaId;
    }

    public MaterielType getMaterielType() {
        return materielType;
    }

    public void setMaterielType(MaterielType materielType) {
        this.materielType = materielType;
    }

    public String getTypeMateriel1() {
        return typeMateriel1;
    }

    public void setTypeMateriel1(String typeMateriel1) {
        this.typeMateriel1 = typeMateriel1;
    }

    public String getTypeMateriel2() {
        return typeMateriel2;
    }

    public void setTypeMateriel2(String typeMateriel2) {
        this.typeMateriel2 = typeMateriel2;
    }

    public String getTypeMateriel3() {
        return typeMateriel3;
    }

    public void setTypeMateriel3(String typeMateriel3) {
        this.typeMateriel3 = typeMateriel3;
    }

    public String getTypeMateriel4() {
        return typeMateriel4;
    }

    public void setTypeMateriel4(String typeMateriel4) {
        this.typeMateriel4 = typeMateriel4;
    }

    public double getUniteParAn() {
        return uniteParAn;
    }

    public void setUniteParAn(double uniteParAn) {
        this.uniteParAn = uniteParAn;
    }

    public String getUnite() {
        return unite;
    }

    public void setUnite(String unite) {
        this.unite = unite;
    }

    public String getHashKey() {
        return hashKey;
    }

    public void setHashKey(String hashKey) {
        this.hashKey = hashKey;
    }

    public String getPerformanceUnite() {
        return performanceUnite;
    }

    public void setPerformanceUnite(String performanceUnite) {
        this.performanceUnite = performanceUnite;
    }

    public Double getPerformance() {
        return performance;
    }

    public void setPerformance(Double performance) {
        this.performance = performance;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        MaterielDto other = (MaterielDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
