package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsList.java 3880 2014-03-27 11:18:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.6/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Domain list action.
 *
 * @author Arnaud Thimel (Code Lutin)
 */
public class DomainsList extends AbstractAgrosystAction {

    private static final long serialVersionUID = -359363226334437151L;

    protected DomainFilter domainFilter;

    protected transient DomainService domainService;

    protected ResultList<DomainDto> domains;

    /** In case of file extension error. */
    protected boolean importFileError;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setImportFileError(boolean importFileError) {
        this.importFileError = importFileError;
    }

    @Override
    public String execute() throws Exception {

        // in case of file type error
        if (importFileError) {
            notificationSupport.importError("Format de fichier incorrect !");
            importFileError = false;
        }

        domainFilter = new DomainFilter();
        NavigationContext navigationContext = getNavigationContext();
        domainFilter.setNavigationContext(navigationContext);
        domainFilter.setPageSize(getConfig().getListResultsPerPage());
        domainFilter.setActive(Boolean.TRUE);
        domains = domainService.getFilteredDomainsDto(domainFilter);
        return SUCCESS;
    }

    public Map<DomainType, String> getTypes() {
        return getEnumAsMap(DomainType.values());
    }

    public DomainFilter getDomainFilter() {
        return domainFilter;
    }

    public ResultList<DomainDto> getDomains() {
        return domains;
    }

}
