package fr.inra.agrosyst.web.actions.user;

import java.util.Map;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.StringUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UserAccount.java 3241 2014-02-14 09:40:30Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/user/UserAccount.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class UserAccount extends AbstractAgrosystAction implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -6751756402587810749L;

    protected transient AgrosystWebApplicationContext context;

    protected transient UserService userService;

    protected Map<String, String[]> bannerMap;

    protected UserDto user;
    
    protected String password;
    
    protected String confirmPassword;

    public void setContext(AgrosystWebApplicationContext context) {
        this.context = context;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public void prepare() throws Exception {
        user = new UserDto();
        // make copy to not modify direct object from session
        Binder<UserDto, UserDto> userDtoBinder = BinderFactory.newBinder(UserDto.class);
        userDtoBinder.copy(session.getAuthenticatedUser(), user);
    }

    public UserDto getUser() {
        if (user == null) {
            // AThimel 26/06/2013 Fais chier de devoir écrire ça, mais c'est la seule option pour ne pas avoir une grosse dose d'exceptions avec du paramsPrepareParams
            return new UserDto();
        }
        return user;
    }

    @Override
    @Action("user-account-input")
    public String input() {
        initForInput();
        return INPUT;
    }

    @Override
    protected void initForInput() {
        bannerMap = context.getBannersMap();
    }

    @Override
    public void validate() {
        
        String email = user.getEmail();
        if (Strings.isNullOrEmpty(email)) {
            addFieldError("user.email", "Le champ 'Email' est obligatoire");
        } else if (!StringUtil.isEmail(email)){
            addFieldError("user.email", "L'adresse email n'est pas valide");
        }

        if (userService.isEmailInUse(email, user.getTopiaId())) {
            addFieldError("user.email", "Cette adresse email est déjà utilisée");
        }
        
        if (!Objects.equal(password, confirmPassword)) {
            addFieldError("confirmPassword", "Les champs 'password' et 'confirmPassword' ne correspondent pas");
        }
        if (Strings.isNullOrEmpty((user.getFirstName()))) {
            addFieldError("authenticatedUser.firstName", "Le champ 'Prénom' est obligatoire");
        }
        if (Strings.isNullOrEmpty((user.getLastName()))) {
            addFieldError("authenticatedUser.lastName", "Le champ 'Nom' est obligatoire");
        }
        
        if (hasErrors()) {
            initForInput();
        }
    }

    @Override
    @Action(results = {
            @Result(type = "redirectAction", params = {"actionName", "user-account-input"})})
    public String execute() {
        user = userService.updateUser(user, password);
        session.setAuthenticatedUser(user);
        notificationSupport.authenticatedUserSaved(user);
        return SUCCESS;
    }

    public Map<String, String[]> getBannerMap() {
        return bannerMap;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }
}
