package fr.inra.agrosyst.web.actions.species;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ListVarietiesJson.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/species/ListVarietiesJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;

import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Action d'autocompletion des variétés:
 * - list-varieties-json
 * - list-porte-greffes-json
 * - list-clone-greffes-json
 * 
 * @author Eric Chatellier
 */
public class ListVarietiesJson extends AbstractJsonAction {

    private static final long serialVersionUID = 5088194867807225637L;

    protected transient ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    protected List<RefVariete> varieties;
    protected List<RefClonePlantGrape> clones;

    protected String speciesId;
    protected String varietyId;
    protected String term;

    public void setSpeciesId(String speciesId) {
        this.speciesId = speciesId;
    }

    public void setVarietyId(String varietyId) {
        this.varietyId = varietyId;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    @Override
    public String execute() {
        varieties = referentialService.findVarietes(speciesId, term);
        return SUCCESS;
    }

    @Action(value="list-graft-support-json")
    public String listGraftSupports() {
        varieties = referentialService.findGraftSupports(term); // No need to take care of the selected species
        return SUCCESS;
    }

    @Action(value="list-graft-clone-json")
    public String listGraftClones() {
        clones = referentialService.findGraftClones(speciesId, varietyId, term);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        if (clones != null) {
            return clones;
        }
        return varieties;
    }

    @Override
    public String input() throws Exception {
        return INPUT;
    }
}
