package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsUnactivate.java 3310 2014-02-18 17:19:36Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsUnactivate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

/**
 * Désactivation multiple de Systèmes synthétisés.
 * 
 */
public class PracticedSystemsUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2031204987636332755L;

    protected transient PracticedSystemService practicedSystemService;

    protected List<String> practicedSystemIds;

    protected boolean activate;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }
    
    public void setPracticedSystemIds(List<String> practicedSystemIds) {
        this.practicedSystemIds = practicedSystemIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "practiced-systems-list" }) })
    public String execute() throws Exception {
        practicedSystemService.unactivatePracticedSystem(practicedSystemIds, activate);
        return SUCCESS;
    }
}
