package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefStadesEdiJson.java 3150 2014-02-07 08:55:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadRefStadesEdiJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.inra.agrosyst.api.services.practiced.RefStadeEdiDto;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Chargement des StadeEdis
 *
 * @author cosse
 */
public class LoadRefStadesEdiJson extends AbstractJsonAction {

    private static final long serialVersionUID = 4680946995049096766L;

    private static final Log log = LogFactory.getLog(LoadRefStadesEdiJson.class);

    protected transient ReferentialService referentialService;

    protected String vegetativeProfile;

    protected List<RefStadeEdiDto> result;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setVegetativeProfile(String vegetativeProfile) {
        this.vegetativeProfile = vegetativeProfile;
    }

    @Override
    public String execute() throws Exception {

        Integer vegetativeProfileRaw = null;

        try {
            vegetativeProfileRaw = Integer.valueOf(vegetativeProfile);
        } catch (NumberFormatException nfe) {
            if (log.isWarnEnabled()) {
                log.warn("Unable to parse integer: " + vegetativeProfile);
            }
        }
        result = referentialService.getRefStadesEdi(vegetativeProfileRaw);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return result;
    }

}
