package fr.inra.agrosyst.web.actions.performances;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PerformancesListJson.java 3848 2014-03-23 20:48:50Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/performances/PerformancesListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.performance.PerformanceDto;
import fr.inra.agrosyst.api.services.performance.PerformanceFilter;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class PerformancesListJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1180723133330637375L;

    protected transient PerformanceService performanceService;

    protected String filter;

    protected ResultList<PerformanceDto> performances;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    public String execute() {
        PerformanceFilter performanceFilter = getGson().fromJson(filter, PerformanceFilter.class);
        performanceFilter.setPageSize(getConfig().getListResultsPerPage());
        performanceFilter.setActive(Boolean.TRUE);
        //performanceFilter.setPracticed(practiced);
        performances = performanceService.getFilteredPerformances(performanceFilter);
        return SUCCESS;
    }

    public ResultList<PerformanceDto> getPerformances() {
        return performances;
    }

    @Override
    public Object getJsonData() {
        return performances;
    }

}
