package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ManagementModesEditJson.java 3397 2014-02-21 14:25:29Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/ManagementModesEditJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import org.apache.struts2.convention.annotation.Action;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Management mode edit json actions.
 * 
 * @author Eric Chatellier
 */
public class ManagementModesEditJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3260095596557765111L;

    protected transient GrowingSystemService growingSystemService;

    protected transient ManagementModeService managementModeService;

    /** Growing system id (for decision-rules-edit-cropping-plan-entries-json). */
    protected String growingSystemTopiaId;

    /** Type de bio agresseur (for management-edit-bio-agressors-json). */
    protected BioAgressorType bioAgressorType;

    protected ManagementModeCategory category;

    protected Object jsonData;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setBioAgressorType(BioAgressorType bioAgressorType) {
        this.bioAgressorType = bioAgressorType;
    }

    /**
     * Récupération de la liste des cultures et des règles à la sélection d'un système de culture.
     * 
     * @return SUCCESS
     */
    @Action("management-modes-edit-growing-system-data-json")
    public String listCroppingPlanEntries() {
        GrowingSystem growingSystem = growingSystemService.getGrowingSystem(growingSystemTopiaId);
        String domainTopiaId = growingSystem.getGrowingPlan().getDomain().getTopiaId();

        List<CroppingPlanEntry> croppingPlanEntries = managementModeService.getGrowingSystemCroppingPlanEntries(growingSystemTopiaId);
        Collection<DecisionRule> decisionRules = managementModeService.getGrowingSystemDecisionRules(growingSystemTopiaId);
        List<ManagementModeCategory> availableManagementModeCategories = managementModeService.getAvailableManagementModeCategories(growingSystemTopiaId);

        Map<String, Object> result = Maps.newHashMap();
        result.put("croppingPlanEntries", croppingPlanEntries);
        result.put("decisionRules", decisionRules);
        result.put("managementModeCategories", availableManagementModeCategories);
        result.put("domainTopiaId", domainTopiaId);
        jsonData = result;
        return SUCCESS;
    }

    /**
     * Recuperation de la liste des bio agresseurs filtrée par type.
     * 
     * @return SUCCESS
     */
    @Action("management-modes-edit-bio-agressors-json")
    public String listBioAgressors() {
        jsonData = managementModeService.getBioAgressors(bioAgressorType);
        return SUCCESS;
    }

    @Action("available-growing-system-for-duplication-json")
    public String availableGrowingSystemsForDuplication() {
        NavigationContext navigationContext = getNavigationContext();
        jsonData = managementModeService.getAvailableGsForDuplication(growingSystemTopiaId, navigationContext);
        return SUCCESS;
    }


    @Override
    public Object getJsonData() {
        return jsonData;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public void setCategory(ManagementModeCategory category) {
        this.category = category;
    }

}
