package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveMeasurementsImport.java 3880 2014-03-27 11:18:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveMeasurementsImport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Import measurements XLS file.
 * 
 * @author Eric Chatellier
 */
@Results({
        @Result(type = "redirectAction", name = "input", params = {"actionName", "effective-crop-cycles-list", "measurement", "true", "importFileError", "true"})
})
public class EffectiveMeasurementsImport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(EffectiveMeasurementsImport.class);

    private static final long serialVersionUID = 2031204987636332755L;

    protected File file;

    public void setFile(File file) {
        this.file = file;
    }

    protected transient MeasurementService measurementService;

    public void setMeasurementService(MeasurementService measurementService) {
        this.measurementService = measurementService;
    }

    @Override
    @Action(results = {
            @Result(type = "redirectAction", params = {"actionName", "effective-crop-cycles-list", "measurement", "true"})})
    public String execute() throws Exception {
        InputStream stream = null;
        try {
            stream = new FileInputStream(file);
            measurementService.importEffectiveMeasurementsForXlsStream(stream);
            notificationSupport.importSuccess();
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import xls file", ex);
            }
            notificationSupport.importError(ex.getMessage());
        } finally {
            IOUtils.closeQuietly(stream);
        }
        return SUCCESS;
    }
}
