package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveCropCyclesList.java 3880 2014-03-27 11:18:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveCropCyclesList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.effective.EffectiveZoneFilter;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Display plots list that may be associated (or not) with crop cycles and cropping plan
 * intervention.
 * 
 * @author Eric Chatellier
 */
public class EffectiveCropCyclesList extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7710481757962881593L;

    protected transient EffectiveCropCycleService effectiveCropCycleService;

    /** Liste des zones (point d'entrée des cycles réalisés). */
    protected ResultList<ZoneDto> zoneListResult;

    /** Flag to use current zone list as entry point for measurement. */
    protected boolean measurement;

    /** In case of file extension error. */
    protected boolean importFileError;

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setImportFileError(boolean importFileError) {
        this.importFileError = importFileError;
    }

    @Override
    public String execute() throws Exception {
        
        // in case of file type error
        if (importFileError) {
            notificationSupport.importError("Format de fichier incorrect !");
            importFileError = false;
        }

        EffectiveZoneFilter plotFilter = new EffectiveZoneFilter();
        NavigationContext navigationContext = getNavigationContext();
        plotFilter.setNavigationContext(navigationContext);
        plotFilter.setPageSize(getConfig().getListResultsPerPage());
        zoneListResult = effectiveCropCycleService.getFilteredZonesDto(plotFilter);
        return SUCCESS;
    }

    public ResultList<ZoneDto> getZoneListResult() {
        return zoneListResult;
    }

    public boolean isMeasurement() {
        return measurement;
    }

    public void setMeasurement(boolean measurement) {
        this.measurement = measurement;
    }
}
