package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsUnactivate.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsUnactivate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Désactivation multiple de domaines.
 * 
 * @author Eric Chatellier
 */
public class DomainsUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2031204987636332755L;

    protected transient DomainService domainService;

    protected List<String> domainIds;

    protected boolean activate;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }
    
    public void setDomainIds(List<String> domainIds) {
        this.domainIds = domainIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "domains-list" }) })
    public String execute() throws Exception {
        domainService.unactivateDomains(domainIds, activate);
        return SUCCESS;
    }
}
