package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsExtend.java 3150 2014-02-07 08:55:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsExtend.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.domain.DomainExtendException;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Prolongation d'un domaine.
 * 
 * @author Eric Chatellier
 */
public class DomainsExtend extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2031204987636332755L;

    protected transient DomainService domainService;

    /** Au pluriel car interface communes avec la liste, ne pas modifier. */
    protected String domainIds;

    /** Campagne associée au nouveau domaine. */
    protected int extendCampaign;

    /** Duplicated domain. */
    protected Domain domain;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setDomainIds(String domainIds) {
        this.domainIds = domainIds;
    }

    public void setExtendCampaign(int extendCampaign) {
        this.extendCampaign = extendCampaign;
    }
    
    
    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "domains-edit-input", "domainTopiaId", "${domain.topiaId}"}),
            @Result(name = ERROR, type = "redirectAction", params = {"actionName", "domains-list"})})
    public String execute() throws Exception {
        try {
            domain = domainService.extendDomain(domainIds, extendCampaign);

            navigationContextEntityCreated(domain);

        } catch (DomainExtendException e) {
            notificationSupport.domainExtendError(String.format("Ce domaine existe déjà en %d. La prolongation sur cette campagne n'est pas autorisée.",
                    extendCampaign));
            return ERROR;
        }

        return SUCCESS;
    }

    public Domain getDomain() {
        return domain;
    }
}
