package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AttachmentsDownload.java 3150 2014-02-07 08:55:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/AttachmentsDownload.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.AttachmentMetadata;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * This is the default action used to upload a file attached to a given object reference ID.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class AttachmentsDownload extends AbstractAgrosystAction {

    private static final long serialVersionUID = 1864154104471757665L;

    private static final Log log = LogFactory.getLog(AttachmentsDownload.class);

    protected transient AttachmentService attachmentService;

    protected String attachmentTopiaId;

    protected AttachmentMetadata attachmentMetadata;

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public void setAttachmentTopiaId(String attachmentTopiaId) {
        this.attachmentTopiaId = attachmentTopiaId;
    }

    public AttachmentMetadata getAttachmentMetadata() {
        return attachmentMetadata;
    }

    @Override
    @Action(results= {
            @Result(type="stream",
                    params={
                        "contentType", "${attachmentMetadata." + AttachmentMetadata.PROPERTY_CONTENT_TYPE + "}",
                        "inputName", "inputStream",
                        "contentDisposition", "attachment; filename=\"${attachmentMetadata." + AttachmentMetadata.PROPERTY_NAME + "}\""
                    }
            )
    })
    public String execute() throws Exception {
        attachmentMetadata = attachmentService.getAttachmentMetadata(attachmentTopiaId);
        return SUCCESS;
    }
    
    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            inputStream = attachmentService.getAttachmentContent(attachmentTopiaId);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't download file", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }
}
