package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystStringToDateConverter.java 3847 2014-03-22 01:39:13Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/AgrosystStringToDateConverter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.apache.struts2.util.StrutsTypeConverter;

import com.google.common.base.Strings;

/**
 * @author David Cossé
 */
public class AgrosystStringToDateConverter extends StrutsTypeConverter {
    public Object convertFromString(Map context, String[] values, Class toClass) {
        //Parse String to get a date object
        Date result = null;
        if(values != null && values.length == 1) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            try {
                String stDate = values[0];
                if(!Strings.isNullOrEmpty(stDate)) {
                    result = simpleDateFormat.parse(values[0]);
                }
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }

        return result;
    }

    public String convertToString(Map context, Object o) {
        // Get the string from object o
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        String result = simpleDateFormat.format(o);
        return result;
    }
}
