package fr.inra.agrosyst.web.actions.auth;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: FeedbackJson.java 3523 2014-02-27 13:30:50Z sbavencoff $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.5/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/auth/FeedbackJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * Cette action récupère le formulaire de feedback (en json) et l'envoi par mail.
 */
public class FeedbackJson extends AbstractJsonAction {

    private static final long serialVersionUID = -6415308969543420930L;

    protected transient UserService userService;

    protected String clientAppVersion;

    protected String feedback;

    protected String feedbackCategory;

    protected String env;

    protected String location;

    protected String locationTitle;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setClientAppVersion(String clientAppVersion) {
        this.clientAppVersion = clientAppVersion;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setLocationTitle(String locationTitle) {
        this.locationTitle = locationTitle;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public void setFeedbackCategory(String feedbackCategory) { this.feedbackCategory = feedbackCategory; }

    @Override
    public String execute() throws Exception {
        String envInfo = Strings.nullToEmpty(env);
        envInfo += "Adresse IP : " + servletRequest.getRemoteAddr() + "\n";
        envInfo += "Session ID : " + getSessionId() + "\n";
        envInfo += "Version cliente : " + clientAppVersion + "\n";
        envInfo += "Version web : " + getConfig().getApplicationVersion() + "\n";
        userService.sendFeedback(envInfo, location, locationTitle, feedbackCategory, feedback);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return null;
    }
}
