package fr.inra.agrosyst.web.actions.species;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ListSpeciesJson.java 3211 2014-02-12 21:26:53Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.4/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/species/ListSpeciesJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class ListSpeciesJson extends AbstractJsonAction {

    private static final long serialVersionUID = 5088194867807225637L;

    protected transient ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    protected List<RefEspece> species;

    protected String term;

    public void setTerm(String term) {
        this.term = term;
    }

    @Override
    public String execute() {
        species = referentialService.findSpecies(term);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return species;
    }

    @Override
    public String input() throws Exception {
        return INPUT;
    }

}
