package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedPlotsListJson.java 3531 2014-02-27 15:54:43Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.4/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedPlotsListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class PracticedPlotsListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -7042498750101369083L;

    protected transient PracticedPlotService practicedPlotService;

    public void setPracticedPlotService(PracticedPlotService practicedPlotService) {
        this.practicedPlotService = practicedPlotService;
    }

    protected ResultList<PracticedPlotDto> practicedPlots;

    protected String filter;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        PracticedPlotFilter pracfilter = getGson().fromJson(filter, PracticedPlotFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        pracfilter.setNavigationContext(navigationContext);
        practicedPlots = practicedPlotService.getFilteredPracticedPlotsDto(pracfilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return practicedPlots;
    }
}
