package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ManagementModesDuplicate.java 3460 2014-02-25 09:52:01Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.4/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/ManagementModesDuplicate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

/**
 * Created by davidcosse on 17/02/14.
 */
public class ManagementModesDuplicate extends AbstractAgrosystAction{

    protected ManagementModeService managementModeService;

    protected String growingSystemId;

    protected String plannedManagementModeId;

    protected String observedManagementModeId;

    protected ManagementMode managementMode;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setPlannedManagementModeId(String plannedManagementModeId) {
        this.plannedManagementModeId = plannedManagementModeId;
    }

    public void setObservedManagementModeId(String observedManagementModeId) {
        this.observedManagementModeId = observedManagementModeId;
    }

    public String getGrowingSystemId() {
        return growingSystemId;
    }

    public ManagementMode getManagementMode() {
        return managementMode;
    }

    @Action(results = {
    @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "management-modes-edit-input", "growingSystemTopiaId", "${growingSystemId}", "managementModeTopiaId", "${managementMode.topiaId}"}),
    @Result(name = ERROR, type = "redirectAction", params = {"actionName", "management-modes-list"})})
    public String execute() throws Exception {
        if(Strings.isNullOrEmpty(growingSystemId)){
            addActionError("Un système de culture doit être défini sur un mode de gestion");
            return ERROR;
        }
        managementMode = managementModeService.duplicateManagementModes(plannedManagementModeId, observedManagementModeId, growingSystemId);
        notificationSupport.managementModeDuplicated();
        return SUCCESS;
    }

}
