package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DecisionRulesEditJson.java 3550 2014-02-28 22:24:20Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.4/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/DecisionRulesEditJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.struts2.convention.annotation.Action;

import java.util.List;

/**
 * Decision rule edit json actions.
 * 
 * @author Eric Chatellier
 */
public class DecisionRulesEditJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4109060690576341764L;

    protected transient ManagementModeService managementModeService;

    /** Domain topia id (for decision-rules-edit-cropping-plan-entries-json). */
    protected String domainCode;

    /** Growing system id (for decision-rules-edit-cropping-plan-entries-json). */
    protected String growingSystemTopiaId;

    /** Type de bio agresseur (for decision-rules-edit-bio-agressors-json). */
    protected BioAgressorType bioAgressorType;

    protected String bioAgressorTopiaId;

    protected String decisionRuleName;

    protected AgrosystInterventionType agrosystInterventionType;

    protected String croppingPlanEntryId;

    protected Object jsonData;

    protected List<String> requiredDecisionRules;

    public void setRequiredDecisionRules(List<String> requiredDecisionRules) {
        this.requiredDecisionRules = requiredDecisionRules;
    }

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public void setBioAgressorType(BioAgressorType bioAgressorType) {
        this.bioAgressorType = bioAgressorType;
    }

    public void setDecisionRuleName(String decisionRuleName) {
        this.decisionRuleName = decisionRuleName;
    }

    public void setAgrosystInterventionType(AgrosystInterventionType agrosystInterventionType) {
        this.agrosystInterventionType = agrosystInterventionType;
    }

    public void setCroppingPlanEntryId(String croppingPlanEntryId) {
        this.croppingPlanEntryId = croppingPlanEntryId;
    }

    public void setBioAgressorTopiaId(String bioAgressorTopiaId) {
        this.bioAgressorTopiaId = bioAgressorTopiaId;
    }

    /**
     * Récupération de la liste des cultures à la sélection d'un système de culture.
     * 
     * @return SUCCESS
     */
    @Action("decision-rules-edit-cropping-plan-entries-json")
    public String listCroppingPlanEntries() {
        jsonData = managementModeService.getDomainCodeCroppingPlanEntries(domainCode);
        return SUCCESS;
    }

    /**
     * Recuperation de la liste des bio agresseurs filtrée par type.
     * 
     * @return SUCCESS
     */
    @Action("decision-rules-edit-bio-agressors-json")
    public String listBioAgressors() {
        jsonData = managementModeService.getBioAgressors(bioAgressorType);
        return SUCCESS;
    }

    @Action("create-decision-rules-edit-json")
    public String createDecisionRules() {
        jsonData = managementModeService.createNewDecisionRule(
                agrosystInterventionType,
                growingSystemTopiaId,
                bioAgressorType,
                bioAgressorTopiaId,
                croppingPlanEntryId,
                decisionRuleName);
        return SUCCESS;
    }

    @Action("load-required-decision-rules-json")
    public String loadRequiredDecisionRules() {
        jsonData = managementModeService.getAllDecisionRules(requiredDecisionRules);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }
}
