package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsListJson.java 3546 2014-02-27 22:04:06Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.4/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Action de recuperation de la liste paginées des domaines (AJAX).
 * 
 * @author Eric Chatellier
 */
public class DomainsListJson extends AbstractJsonAction {

    private static final long serialVersionUID = 8462808027355013164L;

    protected transient DomainService domainService;

    protected boolean fromNavigationContextChoose = false;
    protected String filter;
    protected Set<Integer> selectedCampaigns = Sets.newHashSet();
    protected Set<String> selectedNetworks = Sets.newHashSet();

    protected ResultList<DomainDto> domains;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setFromNavigationContextChoose(boolean fromNavigationContextChoose) {
        this.fromNavigationContextChoose = fromNavigationContextChoose;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    public void setSelectedNetworks(Set<String> selectedNetworks) {
        this.selectedNetworks = selectedNetworks;
    }

    @Override
    public String execute() {
        DomainFilter domainFilter = getGson().fromJson(filter, DomainFilter.class);
        NavigationContext navigationContext;
        if (fromNavigationContextChoose) {
            navigationContext = new NavigationContext();
            navigationContext.setCampaigns(selectedCampaigns);
            navigationContext.setNetworks(selectedNetworks);
        } else {
            navigationContext = getNavigationContext();
        }
        domainFilter.setNavigationContext(navigationContext);

        domains = domainService.getFilteredDomainsDto(domainFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return domains;
    }
}
