package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AttachmentsDeleteJson.java 3241 2014-02-14 09:40:30Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.4/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/AttachmentsDeleteJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.common.AttachmentService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * This is the default action used to upload a file attached to a given object reference ID.
 *
 * @author <a href="mailto:sebastien.grimault@makina-corpus.com">S. Grimault</a>
 */
public class AttachmentsDeleteJson extends AbstractJsonAction {

    private static final long serialVersionUID = 1864154104471757665L;

    protected transient AttachmentService attachmentService;

    protected String attachmentTopiaId;

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public void setAttachmentTopiaId(String attachmentTopiaId) {
        this.attachmentTopiaId = attachmentTopiaId;
    }

    @Override
    public String execute() throws Exception {
        attachmentService.delete(attachmentTopiaId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return null;
    }
}
