package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystValidationState.java 2861 2014-01-24 10:20:46Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.4/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/AgrosystValidationState.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Date;

/**
 * Représentation l'état de validation d'une entité quelconque. Ce bean permet de savoir si l'utilisateur courant a le
 * droit de valider, si l'entité a évolué depuis sa dernière validation ainsi que la date de dernière validation.
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 * @since 0.8
 */
public class AgrosystValidationState implements Serializable {

    private static final long serialVersionUID = 5481632474364290629L;

    protected boolean userHasValidationPermission;
    protected boolean dirty; // dirty data means that data has been modified since its last validation
    protected Date lastValidationDate;

    public boolean isValidationPossible() {
        return userHasValidationPermission && dirty;
    }

    public boolean isUserHasValidationPermission() {
        return userHasValidationPermission;
    }

    public void setUserHasValidationPermission(boolean userHasValidationPermission) {
        this.userHasValidationPermission = userHasValidationPermission;
    }

    public boolean isDirty() {
        return dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Date getLastValidationDate() {
        return lastValidationDate;
    }

    public void setLastValidationDate(Date lastValidationDate) {
        this.lastValidationDate = lastValidationDate;
    }

}
