package fr.inra.agrosyst.web.actions;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RichNavigationContext.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.4/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/RichNavigationContext.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import com.google.common.base.Function;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.context.NavigationContextService;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class RichNavigationContext {

    protected static final Function<Integer, String> GET_CAMPAIGN_NAME = new Function<Integer, String>() {
        @Override
        public String apply(Integer campaign) {
            String result = String.format("%d (%d - %d)", campaign, campaign - 1, campaign);
            return result;
        }
    };

    protected NavigationContext navigationContext;

    protected NavigationContextService navigationContextService;

    public RichNavigationContext(NavigationContext navigationContext, NavigationContextService navigationContextService) {
        this.navigationContext = navigationContext;
        this.navigationContextService = navigationContextService;
    }

    public int getCampaignsCount() {
        return navigationContext.getCampaignsCount();
    }

    public Map<Integer, String> getCampaigns() {
        int index = 0;
        int max = Integer.MAX_VALUE;
        Map<Integer, String> result = Maps.newLinkedHashMap();
        for (Integer campaign : navigationContext.getCampaigns()) {
            if (index >= max) {
                break;
            }
            index++;
            result.put(campaign, GET_CAMPAIGN_NAME.apply(campaign));
        }
        return result;
    }

    public int getNetworksCount() {
        return navigationContext.getNetworksCount();
    }

    public Map<String, String> getNetworks() {
        Map<String, String> result = navigationContextService.getNetworks(navigationContext.getNetworks(), -1);
        return result;
    }

    public int getDomainsCount() {
        return navigationContext.getDomainsCount();
    }

    public Map<String, String> getDomains() {
        Map<String, String> result = navigationContextService.getDomains(navigationContext.getDomains(), -1);
        return result;
    }

    public int getGrowingPlansCount() {
        return navigationContext.getGrowingPlansCount();
    }

    public Map<String, String> getGrowingPlans() {
        Map<String, String> result = navigationContextService.getGrowingPlans(navigationContext.getGrowingPlans(), -1);
        return result;
    }

    public int getGrowingSystemsCount() {
        return navigationContext.getGrowingSystemsCount();
    }

    public Map<String, String> getGrowingSystems() {
        Map<String, String> result = navigationContextService.getGrowingSystems(navigationContext.getGrowingSystems(), -1);
        return result;
    }

}
