package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsListJson.java 3453 2014-02-25 00:50:50Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class PracticedSystemsListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -7042498750101369083L;

    protected transient PracticedSystemService practicedSystemService;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    protected ResultList<PracticedSystemDto> practicedSystems;

    protected String filter;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        PracticedSystemFilter practicedSystemFilter = getGson().fromJson(filter, PracticedSystemFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        practicedSystemFilter.setNavigationContext(navigationContext);
        practicedSystems = practicedSystemService.getFilteredPracticedSystemsDto(practicedSystemFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return practicedSystems;
    }
}
