package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefMinUnifaShapesJson.java 3241 2014-02-14 09:40:30Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadRefMinUnifaShapesJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadRefMinUnifaShapesJson extends AbstractJsonAction {

    private static final long serialVersionUID = -5676283869376045776L;

    protected transient ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    protected List<String> fertilizerShape;

    protected Integer categ;

    @Override
    public String execute() throws Exception {
        fertilizerShape = referentialService.findAllActiveFertiMinShape(categ);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return fertilizerShape;
    }

    public void setCateg(Integer categ) {
        this.categ = categ;
    }

}
