package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: NetworksListJson.java 3241 2014-02-14 09:40:30Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/NetworksListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 */
public class NetworksListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -1491201850078343786L;

    protected transient NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    protected String filter;

    protected ResultList<Network> networks;

    @Override
    public String execute() {
        NetworkFilter networkFilter = getGson().fromJson(filter, NetworkFilter.class);
        networks = networkService.getFilteredNetworks(networkFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return networks;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

}
