package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: NetworksList.java 3289 2014-02-18 09:31:34Z ymartel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/NetworksList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Set;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.network.NetworkConnectionDto;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.services.network.NetworkGraph;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.network.SmallNetworkDto;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Affichage de la liste des réseaux et du graphique des réseaux.
 *
 * @author cosse
 */
public class NetworksList extends AbstractAgrosystAction {

    private static final long serialVersionUID = 4474047833187143193L;

    protected transient NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    protected ResultList<Network> networks;

    protected NetworkFilter networkFilter;

    protected NetworkGraph networksGraph;

    @Override
    public String execute() throws Exception {
        NavigationContext navigationContext = getNavigationContext();
        networkFilter = new NetworkFilter();
        networkFilter.setNavigationContext(navigationContext);
        networkFilter.setActive(Boolean.TRUE);
        networkFilter.setPageSize(getConfig().getListResultsPerPage());

        networks = networkService.getFilteredNetworks(networkFilter);

        networksGraph = networkService.buildFullNetworkGraph();

        return SUCCESS;
    }

    public ResultList<Network> getNetworks() {
        return networks;
    }

    public List<List<SmallNetworkDto>> getGraphNetworks() {
        return networksGraph.getNetworks();
    }

    public Set<NetworkConnectionDto> getGraphConnections() {
        return networksGraph.getConnections();
    }

    public NetworkFilter getNetworkFilter() {
        return networkFilter;
    }
}
