package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DecisionRulesDuplicate.java 3291 2014-02-18 10:18:56Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/DecisionRulesDuplicate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Duplication unique de dispositif.
 * 
 * @author Eric Chatellier
 */
public class DecisionRulesDuplicate extends AbstractAgrosystAction {

    private static final long serialVersionUID = -4930761732959095035L;

    protected transient ManagementModeService managementModeService;

    protected String decisionRuleIds;

    /** Duplicated decision rule. */
    protected DecisionRule decisionRule;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setDecisionRuleIds(String decisionRuleIds) {
        this.decisionRuleIds = decisionRuleIds;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "decision-rules-edit-input", "decisionRuleCode", "${decisionRule.code}"}),
            @Result(name = ERROR, type = "redirectAction", params = {"actionName", "decision-rules-list"})})
    public String execute() throws Exception {
        decisionRule = managementModeService.duplicateDecisionRule(decisionRuleIds);
        notificationSupport.decisionRuleDuplicated(decisionRule);
        return SUCCESS;
    }
    
    public DecisionRule getDecisionRule() {
        return decisionRule;
    }
}
