package fr.inra.agrosyst.web.actions.managementmodes;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: CreateNewDecisionRuleVersion.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/CreateNewDecisionRuleVersion.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Creates the new version of a decision rule
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class CreateNewDecisionRuleVersion extends AbstractAgrosystAction {

    private static final long serialVersionUID = -7237584971917654739L;

    protected transient ManagementModeService managementModeService;

    protected String decisionRuleCode;

    protected String versionReason;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setDecisionRuleCode(String decisionRuleCode) {
        this.decisionRuleCode = decisionRuleCode;
    }

    public void setVersionReason(String versionReason) {
        this.versionReason = versionReason;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "decision-rules-edit-input", "decisionRuleCode", "${decisionRuleCode}"})})
    public String execute() throws Exception {
        Preconditions.checkState(!Strings.isNullOrEmpty(decisionRuleCode));
        DecisionRule created = managementModeService.createNewDecisonRuleVersion(decisionRuleCode, versionReason);
        notificationSupport.newDecisionRuleCreated(created);
        return SUCCESS;
    }

    public String getDecisionRuleCode() {
        return decisionRuleCode;
    }

}
