package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadAvailableZoneForDuplicationJson.java 3756 2014-03-13 19:17:51Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/LoadAvailableZoneForDuplicationJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadAvailableZoneForDuplicationJson extends AbstractJsonAction {

    protected String zoneId;

    protected PlotService plotService;

    protected List<Zone> zones;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public String execute() {

        zones = plotService.getZonesWithoutCycle(zoneId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return zones;
    }
}
