package fr.inra.agrosyst.web.actions.effective;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EffectiveCropCycleDuplicate.java 3756 2014-03-13 19:17:51Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/effective/EffectiveCropCycleDuplicate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author David Cossé
 */
public class EffectiveCropCycleDuplicate extends AbstractAgrosystAction {

    protected String fromZoneId;

    protected String toZoneId;

    protected EffectiveCropCycleService effectiveCropCycleService;

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setFromZoneId(String fromZoneId) {
        this.fromZoneId = fromZoneId;
    }

    public void setToZoneId(String toZoneId) {
        this.toZoneId = toZoneId;
    }

    public String getToZoneId() {
        return toZoneId;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "effective-crop-cycles-edit-input", "zoneTopiaId", "${toZoneId}"}),
            @Result(name = ERROR, type = "redirectAction", params = {"actionName", "effective-crop-cycles-list"})
    })
    public String execute() {
        if (Strings.isNullOrEmpty(fromZoneId) || Strings.isNullOrEmpty(toZoneId)) {
            notificationSupport.effectiveCropCycleNotDuplicable();
            return ERROR;
        }
        effectiveCropCycleService.duplicateEffectiveCropCycles(fromZoneId, toZoneId);
        notificationSupport.effectiveCropCycleDuplicate();
        return SUCCESS;
    }
}
