package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsImportEdaplos.java 3880 2014-03-27 11:18:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsImportEdaplos.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Import eDaplos xml file.
 * 
 * @author Eric Chatellier
 */
@Results({
        @Result(type = "redirectAction", name = "input", params = {"actionName", "domains-list", "importFileError", "true"})
})
public class DomainsImportEdaplos extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(DomainsImportEdaplos.class);

    private static final long serialVersionUID = 2031204987636332755L;

    protected File file;

    public void setFile(File file) {
        this.file = file;
    }

    protected transient DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    @Action(results = {
            @Result(type = "redirectAction", params = {"actionName", "domains-list"})})
    public String execute() throws Exception {
        InputStream stream = null;
        try {
            stream = new FileInputStream(file);
            domainService.importEdaplos(stream);
            notificationSupport.importSuccess();
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import eDaplos file", ex);
            }
            notificationSupport.importError(ex.getMessage());
        } finally {
            IOUtils.closeQuietly(stream);
        }
        return SUCCESS;
    }
}
