package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ShowGrowingSystemAndNetworkGraphRaw.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/ShowGrowingSystemAndNetworkGraphRaw.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import fr.inra.agrosyst.api.services.network.NetworkGraph;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class ShowGrowingSystemAndNetworkGraphRaw extends AbstractAgrosystAction {

    private static final long serialVersionUID = 235930146604038026L;

    protected transient NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    protected Set<String> parentNetworkIds;
    protected String growingSystemName;

    public void setParentNetworkIds(Set<String> parentNetworkIds) {
        this.parentNetworkIds = parentNetworkIds;
    }

    public void setGrowingSystemName(String growingSystemName) {
        this.growingSystemName = growingSystemName;
    }

    protected NetworkGraph networkGraph;

    @Override
    public String execute() throws Exception {
        if (parentNetworkIds != null) {
            networkGraph = networkService.buildGrowingSystemAndNetworkGraph(growingSystemName, parentNetworkIds);
        }
        return SUCCESS;
    }

    public NetworkGraph getNetworkGraph() {
        return networkGraph;
    }
}
