package fr.inra.agrosyst.web.actions;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystLayoutData.java 3245 2014-02-14 14:24:22Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/AgrosystLayoutData.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class AgrosystLayoutData {

    protected boolean currentUserAnAdmin;
    protected boolean currentUserAnIsDataProcessor;
    protected String currentUserLastName;
    protected String currentUserFirstName;
    protected String currentUserBannerPath;
    protected String currentUserBannerMeta;

    protected NavigationContext navigationContext;

    protected Map<Integer, String> campaigns;
    protected Map<String, String> networks;
    protected Map<String, String> domains;
    protected Map<String, String> growingPlans;
    protected Map<String, String> growingSystems;

    public void setCurrentUserAnAdmin(boolean currentUserAnAdmin) {
        this.currentUserAnAdmin = currentUserAnAdmin;
    }

    public void setCurrentUserAnIsDataProcessor(boolean currentUserAnIsDataProcessor) {
        this.currentUserAnIsDataProcessor = currentUserAnIsDataProcessor;
    }

    public void setCurrentUserLastName(String currentUserLastName) {
        this.currentUserLastName = currentUserLastName;
    }

    public void setCurrentUserFirstName(String currentUserFirstName) {
        this.currentUserFirstName = currentUserFirstName;
    }

    public boolean isCurrentUserAnAdmin() {
        return currentUserAnAdmin;
    }

    public boolean isCurrentUserAnIsDataProcessor() {
        return currentUserAnIsDataProcessor;
    }

    public String getCurrentUserLastName() {
        return currentUserLastName;
    }

    public String getCurrentUserFirstName() {
        return currentUserFirstName;
    }

    public String getCurrentUserBannerPath() {
        return currentUserBannerPath;
    }

    public void setCurrentUserBannerPath(String currentUserBannerPath) {
        this.currentUserBannerPath = currentUserBannerPath;
    }

    public String getCurrentUserBannerMeta() {
        return currentUserBannerMeta;
    }

    public void setCurrentUserBannerMeta(String currentUserBannerMeta) {
        this.currentUserBannerMeta = currentUserBannerMeta;
    }

    public void setNavigationContext(NavigationContext navigationContext) {
        this.navigationContext = navigationContext;
    }

    public void setCampaigns(Map<Integer, String> campaigns) {
        this.campaigns = campaigns;
    }

    public void setNetworks(Map<String, String> networks) {
        this.networks = networks;
    }

    public void setDomains(Map<String, String> domains) {
        this.domains = domains;
    }

    public void setGrowingPlans(Map<String, String> growingPlans) {
        this.growingPlans = growingPlans;
    }


    public void setGrowingSystems(Map<String, String> growingSystems) {
        this.growingSystems = growingSystems;
    }

    public int getCampaignsCount() {
        return navigationContext.getCampaignsCount();
    }

    public int getNetworksCount() {
        return navigationContext.getNetworksCount();
    }

    public int getDomainsCount() {
        return navigationContext.getDomainsCount();
    }

    public int getGrowingPlansCount() {
        return navigationContext.getGrowingPlansCount();
    }

    public int getGrowingSystemsCount() {
        return navigationContext.getGrowingSystemsCount();
    }

    public Map<Integer, String> getCampaigns() {
        return campaigns;
    }

    public Map<String, String> getNetworks() {
        return networks;
    }

    public Map<String, String> getDomains() {
        return domains;
    }

    public Map<String, String> getGrowingPlans() {
        return growingPlans;
    }

    public Map<String, String> getGrowingSystems() {
        return growingSystems;
    }

}
