package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebSession.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.0.3/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebSession.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Set;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.users.UserDto;

/**
 * Unique objet en session qui regroupe les données de session de l'utilisateur
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class AgrosystWebSession implements Serializable {

    private static final long serialVersionUID = 5982394775074128222L;

    /**
     * Clé utilisée pour stocker l'instance de {@link AgrosystWebSession} dans la map de session HTTP.
     */
    public static final String SESSION_PARAMETER = "agrosystSession";

    protected NavigationContext navigationContext;

    protected String authenticationToken;

    protected UserDto authenticatedUser;

    protected Set<AgrosystWebNotification> infoNotifications = Sets.newHashSet();
    
    protected Set<AgrosystWebNotification> warningNotifications = Sets.newHashSet();
    
    protected Set<AgrosystWebNotification> errorNotifications = Sets.newHashSet();

    public NavigationContext getNavigationContext() {
        return navigationContext;
    }

    public void setNavigationContext(NavigationContext navigationContext) {
        this.navigationContext = navigationContext;
    }

    public String getAuthenticationToken() {
        return authenticationToken;
    }

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
        this.authenticatedUser = null; // AThimel 24/09/13 Force refresh
    }

    public UserDto getAuthenticatedUser() {
        return authenticatedUser;
    }

    public void setAuthenticatedUser(UserDto authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
    }

    public Set<AgrosystWebNotification> getInfoNotifications() {
        return infoNotifications;
    }

    public Set<AgrosystWebNotification> getWarningNotifications() {
        return warningNotifications;
    }

    public Set<AgrosystWebNotification> getErrorNotifications() {
        return errorNotifications;
    }
}
