package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadToolsCouplingJson.java 2083 2013-11-08 18:18:23Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadToolsCouplingJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.services.domain.ToolsCouplingDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * @author David Cossé
 */
public class LoadToolsCouplingJson  extends AbstractJsonAction {

    private static final long serialVersionUID = -6352586060492623909L;

    protected PracticedSystemService practicedSystemService;

    protected AgrosystInterventionType agrosystInterventionType;

    protected String growingSystemId;

    protected String campaigns;

    protected List<ToolsCouplingDto> toolsCouplingDtos;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public String execute() {
        toolsCouplingDtos = practicedSystemService.getToolsCouplingModel(growingSystemId, campaigns, agrosystInterventionType);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return toolsCouplingDtos;
    }

    public void setAgrosystInterventionType(AgrosystInterventionType agrosystInterventionType) {
        this.agrosystInterventionType = agrosystInterventionType;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }
}
