package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefMinUnifaJson.java 2316 2013-11-28 16:03:17Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadRefMinUnifaJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referentiels.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * 
 * @author cosse
 */
public class LoadRefMinUnifaJson extends AbstractJsonAction {

    private static final long serialVersionUID = -2051822874070203733L;

    protected Integer categ;

    protected String fertilizerShape;

    protected ReferentielService referentielService;

    protected List<RefFertiMinUNIFA> refFertiMinUnifas;

    protected String productId;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    protected PracticedSystemService practicedSystemService;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    @Override
    public String execute() throws Exception {
        refFertiMinUnifas = referentielService.findAllActiveRefFertiMinUnifaByCategAndShape(categ, fertilizerShape, productId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return refFertiMinUnifas;
    }

    public void setCateg(Integer categ) {
        this.categ = categ;
    }

    public void setFertilizerShape(String fertilizerShape) {
        this.fertilizerShape = fertilizerShape;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }
}
