package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadFertiOrgaJson.java 2420 2013-12-10 10:27:35Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadFertiOrgaJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referentiels.RefFertiOrga;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * @author David Cossé
 */
public class LoadFertiOrgaJson extends AbstractJsonAction {

    private static final long serialVersionUID = 6788304545377822497L;

    protected List<RefFertiOrga> refFertiTypesEffluents;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public String execute() {
        refFertiTypesEffluents = referentielService.findAllActiveRefFertiOrgas();
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return refFertiTypesEffluents;
    }
}
