package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadFertiEngraisOrgsJson.java 2420 2013-12-10 10:27:35Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadFertiEngraisOrgsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referentiels.RefFertiEngraisorg;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * @author David Cossé
 */
public class LoadFertiEngraisOrgsJson extends AbstractJsonAction {

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    protected List<RefFertiEngraisorg> fertiEngraisorgs;

    @Override
    public String execute() {
        fertiEngraisorgs = referentielService.findAllActiveRefFertiorgs();
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return fertiEngraisorgs;
    }
}
