package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadActaTreatmentCodesAndNamesJson.java 2149 2013-11-14 09:16:27Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadActaTreatmentCodesAndNamesJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.Map;

/**
 * @author David Cossé
 */
public class LoadActaTreatmentCodesAndNamesJson extends AbstractJsonAction {

    protected Map<String, String> treatmentCodesAndNames;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public String execute() {
        treatmentCodesAndNames = referentielService.getActaTreatementCodesAndNames();
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return treatmentCodesAndNames;
    }
}
