package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadActaProductsJson.java 2149 2013-11-14 09:16:27Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadActaProductsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referentiels.RefActaTraitementsProduits;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;

/**
 * @author David Cossé
 */
public class LoadActaProductsJson extends AbstractJsonAction {

    protected List<RefActaTraitementsProduits> actaProducts;

    protected ReferentielService referentielService;

    protected String code;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public String execute() {
        actaProducts = referentielService.getActaTraitementsProduits(code);
        return SUCCESS;
    }


    @Override
    public Object getJsonData() {
        return actaProducts;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
