package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadActaProductUnitsJson.java 2276 2013-11-25 16:59:06Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadActaProductUnitsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.referentiels.RefActaDosageSa;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadActaProductUnitsJson extends AbstractJsonAction {

    protected List<RefActaDosageSa> actaProductUnits;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    protected Integer id_produit;

    @Override
    public String execute() {
        actaProductUnits = referentielService.getActaProduitUnits(id_produit);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return actaProductUnits;
    }

    public void setId_produit(Integer id_produit) {
        this.id_produit = id_produit;
    }
}
