/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsEdit.java 2429 2013-12-10 22:28:59Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsEdit.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.plots;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.FrostProtectionType;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.HosesPositionning;
import fr.inra.agrosyst.api.entities.IrrigationSystemType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotImpl;
import fr.inra.agrosyst.api.entities.PompEngineType;
import fr.inra.agrosyst.api.entities.SolWaterPh;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.referentiels.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referentiels.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefSolCaracteristiquesIndigo;
import fr.inra.agrosyst.api.entities.referentiels.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referentiels.RefSolTextureGeppa;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.plot.Plots;
import fr.inra.agrosyst.api.services.plot.SolHorizonDto;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Action d'edition (sans création) d'une parcelle.
 *
 * @author cosse
 */
public class PlotsEdit extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = -1618279547328450777L;

    private static final String REQUIRED_FIELD = "Champ obligatoire";

    protected DomainService domainService;

    protected PlotService plotService;

    protected GrowingSystemService growingSystemService;
    
    protected ReferentielService referentielService;

    /** Edited plot id. */
    protected String plotTopiaId;

    /** Edited plot instance. */
    protected Plot plot;

    /** Related plots. */
    protected LinkedHashMap<Integer, String> relatedPlots;

    /** Plot growings systems select options. */
    protected List<GrowingSystem> growingSystems;

    /** Selected growing system id. */
    protected String growingSystemTopiaId;

    /** Selected location id. */
    protected String locationTopiaId;

    /** Selected domain id (for creation). */
    protected String domainTopiaId;

    /** Selected domain instance. */
    protected Domain domain;

    /** Onglet "zonage", liste de tous les zonages. */
    protected List<RefParcelleZonageEDI> parcelleZonages;

    /** Identifiant selectionnées dans la liste {@code parcelleZonages}. */
    protected List<String> selectedPlotZoningIds;

    /** Selected sol id (sol tab). */
    protected String selectedSolId;

    /** Liste de toutes les sol texture geppa disponibles. */
    protected List<RefSolTextureGeppa> solTextures; 

    /** Identifiant du sol texture sélectionné. */
    protected String selectedSolTextureId;

    /** Liste de toutes les sol profondeur disponibles. */
    protected List<RefSolProfondeurIndigo> solProfondeurs;

    /** Identifiant du sol profondeur sélectionné. */
    protected String selectedSolProfondeurId;

    /** Liste des sols horizons. */
    protected List<SolHorizonDto> solHorizons;

    /** Caracteristiques des sols. */
    protected List<RefSolCaracteristiquesIndigo> solCaracteristiques;

    /** Zone de la parcelle. */
    protected List<Zone> zones;

    /** Referentiel des elements de voisinage. */
    protected List<RefElementVoisinage> adjacentElements;
 
    /** Element de voisinage sélectionnés. */
    protected List<String> adjacentElementIds;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public void prepare() throws Exception {
        plot = plotService.getPlot(plotTopiaId);
    }

    @Override
    @Action("plots-edit-input")
    public String input() throws Exception {
        initForInput();

        if (plot.getLocation() != null) {
            locationTopiaId = plot.getLocation().getTopiaId();
        }
        if (plot.getGrowingSystem() != null) {
            growingSystemTopiaId = plot.getGrowingSystem().getTopiaId();
        }
        if (plot.getPlotZonings() != null) {
            selectedPlotZoningIds = Lists.newArrayList(Iterables.transform(plot.getPlotZonings(), Entities.GET_TOPIA_ID));
        }
        if (plot.getSol() != null) {
            selectedSolId = plot.getSol().getTopiaId();
        }
        if (plot.getSolTexture() != null) {
            selectedSolTextureId = plot.getSolTexture().getTopiaId();
        }
        if (plot.getSolDepth() != null) {
            selectedSolProfondeurId = plot.getSolDepth().getTopiaId();
        }
        if (plot.getSolHorizon() != null) {
            solHorizons = Lists.newArrayList(Lists.transform(plot.getSolHorizon(), Plots.SOL_HORIZON_TO_DTO));
        } else {
            solHorizons = Lists.newArrayList();
        }
        if (plot.getAdjacentElements() != null) {
            adjacentElementIds = Lists.newArrayList(Iterables.transform(plot.getAdjacentElements(), Entities.GET_TOPIA_ID));
        } else {
            adjacentElementIds = Lists.newArrayList();
        }
        zones = plotService.getPlotZones(plot);

        return INPUT;
    }

    
    @Override
    protected void initForInput() {

        if (plot.isPersisted()) {
            domain = plot.getDomain();
            relatedPlots = plotService.getRelatedPlots(plot.getCode());
        } else {
            domain = domainService.getDomain(domainTopiaId);
        }

        growingSystems = growingSystemService.findAllActiveByDomain(domain);
        parcelleZonages = referentielService.getAllActiveParcelleZonage();
        solTextures = referentielService.getAllActiveSolTextures();
        solProfondeurs = referentielService.getAllActiveSolProfondeurs();
        solCaracteristiques = referentielService.getAllActiveSolCaracteristiques();
        adjacentElements = referentielService.getAllActiveElementVoisinages();
    }

    @Override
    public void validate() {
        // domain
        if (StringUtils.isBlank(domainTopiaId)) {
            addActionError("domainTopiaId is required");
        }
        // location
        if (StringUtils.isBlank(locationTopiaId)) {
            addFieldError("locationTopiaId", REQUIRED_FIELD);
        }
        // name
        if (StringUtils.isBlank(plot.getName())) {
            addFieldError("plot.name", REQUIRED_FIELD);
        }
        
        if (hasErrors()) {
            initForInput();
        }
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = { "actionName", "plots-edit-input", "plotTopiaId", "${plot.topiaId}" }) })
    public String execute() throws Exception {
        plot = plotService.updatePlot(plot, domainTopiaId, locationTopiaId, growingSystemTopiaId, selectedPlotZoningIds,
                selectedSolId, selectedSolTextureId, selectedSolProfondeurId, solHorizons, zones, adjacentElementIds);
        notificationSupport.plotSaved(plot);
        return SUCCESS;
    }
    
    public Plot getPlot() {
        if (plot == null) {
            // AThimel 26/06/2013 Fais chier de devoir écrire ça, mais c'est la seule option pour ne pas avoir une grosse dose d'exceptions avec du paramsPrepareParams
            return new PlotImpl();
        }
        return plot;
    }

    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }

    public Domain getDomain() {
        return domain;
    }

    public String getGrowingSystemsJson() {
        String result = "{}";
        if (growingSystems != null) {
            result = getGson().toJson(growingSystems);
        }
        return result;
    }

    public Map<MaxSlope, String> getMaxSlopes() {
        return getEnumAsMap(MaxSlope.values());
    }
    
    public Map<WaterFlowDistance, String> getWaterFlowDistances() {
        return getEnumAsMap(WaterFlowDistance.values());
    }

    public String getPlotTopiaId() {
        return plotTopiaId;
    }

    public void setPlotTopiaId(String plotTopiaId) {
        this.plotTopiaId = plotTopiaId;
    }

    public LinkedHashMap<Integer, String> getRelatedPlots() {
        return relatedPlots;
    }

    public void setLocationTopiaId(String locationTopiaId) {
        this.locationTopiaId = locationTopiaId;
    }

    public String getLocationTopiaId() {
        return locationTopiaId;
    }

    public List<GrowingSystem> getGrowingSystems() {
        return growingSystems;
    }

    public String getGrowingSystemTopiaId() {
        return growingSystemTopiaId;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    public List<RefParcelleZonageEDI> getParcelleZonages() {
        return parcelleZonages;
    }

    public void setSelectedPlotZoningIds(List<String> selectedPlotZoningIds) {
        this.selectedPlotZoningIds = selectedPlotZoningIds;
    }

    public List<String> getSelectedPlotZoningIds() {
        return selectedPlotZoningIds;
    }

    public Map<IrrigationSystemType, String> getIrrigationSystemTypes() {
        return getEnumAsMap(IrrigationSystemType.values());
    }

    public Map<PompEngineType, String> getPompEngineTypes() {
        return getEnumAsMap(PompEngineType.values());
    }

    public Map<HosesPositionning, String> getHosesPositionnings() {
        return getEnumAsMap(HosesPositionning.values());
    }

    public Map<FrostProtectionType, String> getFrostProtectionTypes() {
        return getEnumAsMap(FrostProtectionType.values());
    }

    public Map<SolWaterPh, String> getSolWaterPhs() {
        return getEnumAsMap(SolWaterPh.values());
    }

    public String getSelectedSolId() {
        return selectedSolId;
    }

    public void setSelectedSolId(String selectedSolId) {
        this.selectedSolId = selectedSolId;
    }

    public List<RefSolTextureGeppa> getSolTextures() {
        return solTextures;
    }

    public List<RefSolProfondeurIndigo> getSolProfondeurs() {
        return solProfondeurs;
    }

    public String getSelectedSolTextureId() {
        return selectedSolTextureId;
    }

    public void setSelectedSolTextureId(String selectedSolTextureId) {
        this.selectedSolTextureId = selectedSolTextureId;
    }

    public String getSelectedSolProfondeurId() {
        return selectedSolProfondeurId;
    }

    public void setSelectedSolProfondeurId(String selectedSolProfondeurId) {
        this.selectedSolProfondeurId = selectedSolProfondeurId;
    }

    public List<SolHorizonDto> getSolHorizons() {
        return solHorizons;
    }

    public void setSolHorizons(String json) {
        Type type = new TypeToken<List<SolHorizonDto>>() {
        }.getType();
        this.solHorizons = getGson().fromJson(json, type);
    }

    public List<RefSolCaracteristiquesIndigo> getSolCaracteristiques() {
        return solCaracteristiques;
    }
    
    public List<Zone> getZones() {
        return zones;
    }

    public void setZones(String json) {
        Type type = new TypeToken<List<Zone>>() {
        }.getType();
        this.zones = getGson().fromJson(json, type);
    }

    public Map<ZoneType, String> getZoneTypes() {
        return getEnumAsMap(ZoneType.values());
    }

    public List<RefElementVoisinage> getAdjacentElements() {
        return adjacentElements;
    }

    public List<String> getAdjacentElementIds() {
        return adjacentElementIds;
    }

    public void setAdjacentElementIds(List<String> adjacentElementIds) {
        this.adjacentElementIds = adjacentElementIds;
    }
}
