/*
 * #%L
 * Agrosyst :: Web
 * $Id: PerformancesEditJson.java 2465 2013-12-12 17:35:18Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/performances/PerformancesEditJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.performances;

import java.util.Collections;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.struts2.convention.annotation.Action;

import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Actions json de la page d'edition des performances.
 * 
 * @author Eric Chatellier
 */
public class PerformancesEditJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 525633506544808582L;

    protected GrowingSystemService growingSystemService;
    
    protected PerformanceService performanceService;

    protected List<String> domainIds;
    
    protected List<String> growingSystemIds;
    
    protected List<String> plotIds;

    protected Object jsonData;

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    public void setDomainIds(List<String> domainIds) {
        this.domainIds = domainIds;
    }

    public void setGrowingSystemIds(List<String> growingSystemIds) {
        this.growingSystemIds = growingSystemIds;
    }

    public void setPlotIds(List<String> plotIds) {
        this.plotIds = plotIds;
    }

    @Action("performances-edit-growing-systems-list-json")
    public String listGrowingSystems() {
        if (CollectionUtils.isEmpty(domainIds)) {
            jsonData = Collections.emptyList();
        } else {
            jsonData = performanceService.getGrowingSystems(domainIds);
        }
        return SUCCESS;
    }
    
    @Action("performances-edit-plots-list-json")
    public String listPlots() {
        if (CollectionUtils.isEmpty(domainIds)) {
            jsonData = Collections.emptyList();
        } else {
            jsonData = performanceService.getPlots(domainIds);
        }
        return SUCCESS;
    }
    
    @Action("performances-edit-zones-list-json")
    public String listZones() {
        if (CollectionUtils.isEmpty(plotIds)) {
            jsonData = Collections.emptyList();
        } else {
            jsonData = performanceService.getZones(plotIds);
        }
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }
}
