/*
 * #%L
 * Agrosyst :: Web
 * $Id: PerformancesEdit.java 2469 2013-12-12 18:01:59Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/performances/PerformancesEdit.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.performances;

import java.util.Collections;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.topia.persistence.TopiaEntities;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Performance;
import fr.inra.agrosyst.api.entities.PerformanceImpl;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class PerformancesEdit extends AbstractAgrosystAction implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 525633506544808582L;

    protected PerformanceService performanceService;

    protected GrowingSystemService growingSystemService;
    
    protected DomainService domainService;

    protected Performance performance;

    protected String performanceTopiaId;

    protected List<Domain> domains;

    protected List<GrowingSystem> growingSystems;
    
    protected List<Plot> plots;
    
    protected List<Zone> zones;

    protected List<String> domainIds;
    
    protected List<String> growingSystemIds;

    protected List<String> plotIds;
    
    protected List<String> zoneIds;

    /** Flag used to use interface for practiced or not. */
    protected boolean practiced;

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setDomainIds(List<String> domainIds) {
        this.domainIds = domainIds;
    }

    public List<String> getDomainIds() {
        return domainIds;
    }

    public void setPerformanceTopiaId(String performanceTopiaId) {
        this.performanceTopiaId = performanceTopiaId;
    }

    public String getPerformanceTopiaId() {
        return performanceTopiaId;
    }

    public List<String> getGrowingSystemIds() {
        return growingSystemIds;
    }

    public void setGrowingSystemIds(List<String> growingSystemIds) {
        this.growingSystemIds = growingSystemIds;
    }

    public List<String> getPlotIds() {
        return plotIds;
    }

    public void setPlotIds(List<String> plotIds) {
        this.plotIds = plotIds;
    }

    public List<String> getZoneIds() {
        return zoneIds;
    }

    public void setZoneIds(List<String> zoneIds) {
        this.zoneIds = zoneIds;
    }

    public boolean isPracticed() {
        return practiced;
    }

    public void setPracticed(boolean practiced) {
        this.practiced = practiced;
    }

    public Performance getPerformance() {
        if (performance == null) {
            // EChatellier 27/06/2013 Fais chier de devoir écrire ça, mais c'est la seule option pour ne pas avoir une grosse dose d'exceptions avec du paramsPrepareParams
            return new PerformanceImpl();
        }
        return performance;
    }

    @Override
    public void prepare() throws Exception {
        performance = performanceService.getPerformance(performanceTopiaId);
    }

    @Override
    @Action("performances-edit-input")
    public String input() throws Exception {

        if (performance.getDomains() != null) {
            domainIds = Lists.newArrayList(Iterables.transform(performance.getDomains(), TopiaEntities.getTopiaIdFunction()));
        } else {
            domainIds = Collections.emptyList();
        }
        if (performance.getGrowingSystems() != null) {
            growingSystemIds = Lists.newArrayList(Iterables.transform(performance.getGrowingSystems(), TopiaEntities.getTopiaIdFunction()));
        } else {
            growingSystemIds = Collections.emptyList();
        }
        if (performance.getPlots() != null) {
            plotIds = Lists.newArrayList(Iterables.transform(performance.getPlots(), TopiaEntities.getTopiaIdFunction()));
        } else {
            plotIds = Collections.emptyList();
        }
        if (performance.getZones() != null) {
            zoneIds = Lists.newArrayList(Iterables.transform(performance.getZones(), TopiaEntities.getTopiaIdFunction()));
        } else {
            zoneIds = Collections.emptyList();
        }

        initForInput();

        return INPUT;
    }

    @Override
    protected void initForInput() {
        // domain
        DomainFilter domainFilter = new DomainFilter();
        NavigationContext navigationContext = getNavigationContext();
        domainFilter.setNavigationContext(navigationContext);
        domainFilter.setActive(true);
        domainFilter.setPageSize(GrowingPlanFilter.ALL_PAGE_SIZE);
        ResultList<Domain> domainListResult = domainService.getFilteredDomains(domainFilter);
        domains = domainListResult.getElements();

        if (CollectionUtils.isNotEmpty(domainIds)) {
            growingSystems = performanceService.getGrowingSystems(domainIds);
        }
        if (CollectionUtils.isNotEmpty(domainIds)) {
            plots = performanceService.getPlots(domainIds);
        }
        if (CollectionUtils.isNotEmpty(plotIds)) {
            zones = performanceService.getZones(plotIds);
        }
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {"actionName", "performances-edit-input", "performanceTopiaId", "${performance.topiaId}", "practiced", "${practiced}"})})
    public String execute() {

        // special management for 'practiced' flag
        if (!performance.isPersisted()) {
            performance.setPracticed(practiced);
        }
        performance = performanceService.updatePerformance(performance, domainIds, growingSystemIds, plotIds, zoneIds);
        notificationSupport.performanceSaved(performance);

        return SUCCESS;
    }

    public List<Domain> getDomains() {
        return domains;
    }

    public List<GrowingSystem> getGrowingSystems() {
        return growingSystems;
    }

    public List<Plot> getPlots() {
        return plots;
    }

    public List<Zone> getZones() {
        return zones;
    }
}
