package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: NetworksListJson.java 1822 2013-10-22 14:48:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/NetworksListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.network.NetworkFilter;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 */
public class NetworksListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -1491201850078343786L;

    protected NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    protected String filter;

    protected ResultList<Network> networks;

    @Override
    public String execute() {
        NetworkFilter networkFilter = getGson().fromJson(filter, NetworkFilter.class);
        networks = networkService.getFilteredNetworks(networkFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return networks;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

}
