package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ValidateGrowingSystem.java 2378 2013-12-04 18:12:48Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.8.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/ValidateGrowingSystem.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Validation d'un SdC.
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 * @since 0.8
 */
public class ValidateGrowingSystem extends AbstractAgrosystAction {

    private static final long serialVersionUID = -6811793980746461606L;

    protected GrowingSystemService growingSystemService;

    protected String growingSystemTopiaId;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }

    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "growing-systems-edit-input", "growingSystemTopiaId", "${growingSystemTopiaId}"})})
    public String execute() throws Exception {
        GrowingSystem growingSystem = growingSystemService.validate(growingSystemTopiaId);

        notificationSupport.growingSystemValidated(growingSystem);
        return SUCCESS;
    }

    public String getGrowingSystemTopiaId() {
        return growingSystemTopiaId;
    }
}
